<?php

namespace Elementor;

class tronix_footer_template_five extends Widget_Base
{

    public function get_name()
    {

        return 'tronix_footer_template_five';
    }

    public function get_title()
    {
        return esc_html__('Tronix Footer Template V5', 'tronixcore');
    }
    public function get_icon()
    {

        return 'eicon-shape';
    }

    public function get_categories()
    {
        return ['tronix_footer_template'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'footer_icon_box',
            [
                'label' => esc_html__('Footer Top Content', 'tronixcore'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'enable_footer_top',
            [
                'label'        => esc_html__('Enable Footer Top', 'tronixcore'),
                'type'         => \Elementor\Controls_Manager::SWITCHER,
                'label_on'     => esc_html__('Show', 'tronixcore'),
                'label_off'    => esc_html__('Hide', 'tronixcore'),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );
        $this->add_control(
            'enable_footer_logo',
            [
                'label'        => esc_html__('Enable Logo', 'tronixcore'),
                'type'         => \Elementor\Controls_Manager::SWITCHER,
                'label_on'     => esc_html__('Show', 'tronixcore'),
                'label_off'    => esc_html__('Hide', 'tronixcore'),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );
        $this->add_control(
            'ft_image',
            [
                'label' => esc_html__('Choose Logo', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'condition' => [
                    'enable_footer_logo' => 'yes',
                    'enable_footer_top' => 'yes',
                ],
            ]
        );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'ft_icon',
            [
                'label' => esc_html__('Icon', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-map-marker-alt',
                    'library' => 'fa-solid',
                ],
            ]
        );

        $repeater->add_control(
            'ft_title',
            [
                'label' => esc_html__('Label', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block'   => true,
            ]
        );

        $repeater->add_control(
            'ft_des',
            [
                'label' => esc_html__('Title', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'label_block'   => true,
            ]
        );

        $this->add_control(
            'ft_icon_box_list',
            [
                'label'   => esc_html__('Icon Box List', 'tronixcore'),
                'type'    => \Elementor\Controls_Manager::REPEATER,
                'fields'  => $repeater->get_controls(),
                'default' => [

                    [
                        'ft_title' => esc_html__('Phone Number', 'tronixcore'),
                        'ft_des' => esc_html__('(+202) 2156-2145', 'tronixcore'),
                        'ft_icon' => [
                            'value'   => 'fas fa-phone-alt',
                            'library' => 'fa-regular',
                        ],
                    ],
                    [
                        'ft_title' => esc_html__('Email Us Here', 'tronixcore'),
                        'ft_des' => esc_html__('info@tronix.com', 'tronixcore'),
                        'ft_icon' => [
                            'value'   => 'fas fa-envelope',
                            'library' => 'fa-regular',
                        ],
                    ],
                    [
                        'ft_title' => esc_html__('Office Address', 'tronixcore'),
                        'ft_des' => esc_html__('251 Hilton, Berlin DE', 'tronixcore'),
                        'ft_icon' => [
                            'value'   => 'fas fa-map-marker-alt',
                            'library' => 'fa-regular',
                        ],
                    ],

                ],
                'title_field' => '{{{ ft_title }}}',
                'condition' => [
                    'enable_footer_top' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();
        // Footer Default Widget Section
        $this->start_controls_section(
            'widget_area_enable',
            [
                'label' => esc_html__('Widget Area', 'tronixcore'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'edit_widget_from_appearance',
            [
                'label'     => esc_html__('Edit Widget From Appearance?', 'tronixcore'),
                'type'      => Controls_Manager::SWITCHER,
                'label_on'  => esc_html__('Yes', 'tronixcore'),
                'label_off' => esc_html__('No', 'tronixcore'),
                'default'   => 'no',
                'description'   => esc_html__('If this option is enable then you can add / remove / edit widgets from Appearance -> Widgets -> Footer Widgets. If Disable you can only edit widgets from here.', 'tronixcore'),
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'company_info',
            [
                'label' => esc_html__('Company Info', 'tronixcore'),
                'tab'   => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'edit_widget_from_appearance!' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'enable_company_info',
            [
                'label' => esc_html__('Enable Section', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'tronixcore'),
                'label_off' => esc_html__('Hide', 'tronixcore'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'enable_company_logo',
            [
                'label' => esc_html__('Enable Logo', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'tronixcore'),
                'label_off' => esc_html__('Hide', 'tronixcore'),
                'return_value' => 'yes',
                'default' => 'no',
                'condition' => [
                    'enable_company_info' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'company_title',
            [
                'label' => esc_html__('Title', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('About Company', 'tronixcore'),
                'dynamic' => [
                    'active' => true,
                ],
                'condition' => [
                    'enable_company_info' => 'yes',
                    'enable_company_logo!' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'company_logo',
            [
                'label' => esc_html__('Choose Image', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'condition' => [
                    'enable_company_info' => 'yes',
                    'enable_company_logo' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'description',
            [
                'label' => esc_html__('Description', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'rows' => 8,
                'default' => esc_html__('At TechPros Solutions, we are about technology and dedicated to providing IT solutions for businesses of all sizes.', 'tronixcore'),
                'dynamic' => [
                    'active' => true,
                ],
                'condition' => [
                    'enable_company_info' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'enable_social',
            [
                'label' => esc_html__('Enable Social Link', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'tronixcore'),
                'label_off' => esc_html__('Hide', 'tronixcore'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'social_label',
            [
                'label' => esc_html__('Label', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::TEXT,

            ]
        );

        $repeater->add_control(
            'social_icon',
            [
                'label' => esc_html__('Icon', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fab fa-facebook-f',
                    'library' => 'fa-solid',
                ],
            ]
        );

        $repeater->add_control(
            'social_link',
            [
                'label' => esc_html__('Icon', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::URL,
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'value' => 'fas fa-arrow-right',
                    'library' => 'flaticon',
                ],
                'label_block' => true,
            ]
        );

        $this->add_control(
            'socials',
            [
                'label'   => esc_html__('Social Info', 'tronixcore'),
                'type'    => \Elementor\Controls_Manager::REPEATER,
                'fields'  => $repeater->get_controls(),
                'default' => [
                    [
                        'social_label' => esc_html__('Facebook', 'tronixcore'),
                        'social_icon' => [
                            'value'   => 'fab fa-facebook-f',
                            'library' => 'fa-regular',
                        ],
                    ],
                    [
                        'social_label' => esc_html__('Twitter', 'tronixcore'),
                        'social_icon' => [
                            'value'   => 'fab fa-twitter',
                            'library' => 'fa-regular',
                        ],
                    ],
                    [
                        'social_label' => esc_html__('Linkedin', 'tronixcore'),
                        'social_icon' => [
                            'value'   => 'fab fa-linkedin-in',
                            'library' => 'fa-regular',
                        ],
                    ],
                ],
                'title_field' => '{{{ social_label }}}',
                'condition' => [
                    'enable_social' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();


        // Page Link Section 

        $this->start_controls_section(
            'page_link_section',
            [
                'label' => esc_html__('Page Link Section', 'tronixcore'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'edit_widget_from_appearance!' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'page_enable',
            [
                'label' => esc_html__('Enable Page', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'tronixcore'),
                'label_off' => esc_html__('Hide', 'tronixcore'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'page_link_title',
            [
                'label' => esc_html__('Title', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Useful Links', 'tronixcore'),
                'dynamic' => [
                    'active' => true,
                ],
                'condition' => [
                    'page_enable' => 'yes',
                ],
            ]
        );

        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'quick_link_icon',
            [
                'label' => esc_html__('Icon', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-arrow-right',
                    'library' => 'flaticon',
                ],
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'page_link_text',
            [
                'label' => esc_html__('Link Text', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Service', 'tronixcore'),
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );
        $repeater->add_control(
            'page_links',
            [
                'label' => esc_html__('Link', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::URL,
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                ],
                'label_block' => true,
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );
        $this->add_control(
            'links',
            [
                'label'   => esc_html__('Page List', 'tronixcore'),
                'type'    => \Elementor\Controls_Manager::REPEATER,
                'fields'  => $repeater->get_controls(),
                'default' => [
                    [
                        'page_link_text' => esc_html('About'),
                        'page_links' => '#',
                    ],
                    [
                        'page_link_text' => esc_html('Meet Our Team'),
                        'page_links' => '#',
                    ],
                    [
                        'page_link_text' => esc_html('News & Media'),
                        'page_links' => '#',
                    ],
                    [
                        'page_link_text' => esc_html('Our Projects'),
                        'page_links' => '#',
                    ],
                    [
                        'page_link_text' => esc_html('Contact Us'),
                        'page_links' => '#',
                    ],
                ],
                'title_field' => '{{{ page_link_text }}}',
                'condition' => [
                    'page_enable' => 'yes',
                ],
            ]
        );

        $this->add_responsive_control(
            'tronix_footer_justify_page',
            [
                'label' => esc_html__('Justify Alignmnet', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'flex-start' => [
                        'title' => esc_html__('Left', 'tronixcore'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'tronixcore'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'flex-end' => [
                        'title' => esc_html__('Right', 'tronixcore'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .footer-justify1' => 'justify-content: {{VALUE}};',
                ],
                'condition' => [
                    'page_enable' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();


        // Contact Section
        $this->start_controls_section(
            'contact_sectioin',
            [
                'label' => esc_html__('Service List', 'tronixcore'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'edit_widget_from_appearance!' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'enable_service_info',
            [
                'label' => esc_html__('Enable Section', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'tronixcore'),
                'label_off' => esc_html__('Hide', 'tronixcore'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'service_section_title',
            [
                'label' => esc_html__('Title', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('What We Do', 'tronixcore'),
                'dynamic' => [
                    'active' => true,
                ],
                'condition' => [
                    'enable_service_info' => 'yes',
                ],
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'sercvice_info_icon',
            [
                'label' => esc_html__('Icon', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-arrow-right',
                    'library' => 'fa-solid',
                ],

            ]
        );

        $repeater->add_control(
            'sercvice_info_list',
            [
                'label' => esc_html__('Title', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'button_url',
            [
                'label'       => esc_html__('Button Link', 'tronixcore'),
                'type'        => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'tronixcore'),
                'options'     => ['url', 'is_external', 'nofollow'],
                'default'     => [
                    'url'               => '',
                    'is_external'       => true,
                    'nofollow'          => true,
                    'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );
        $this->add_control(
            'service',
            [
                'label'   => esc_html__('Service List', 'tronixcore'),
                'type'    => \Elementor\Controls_Manager::REPEATER,
                'fields'  => $repeater->get_controls(),
                'default' => [
                    [
                        'sercvice_info_list' => esc_html__('Cyber Security', 'tronixcore'),
                    ],
                    [
                        'sercvice_info_list' => esc_html__('IT Management', 'tronixcore'),
                    ],
                    [
                        'sercvice_info_list' => esc_html__('QA & Testing', 'tronixcore'),
                    ],
                    [
                        'sercvice_info_list' => esc_html__('Infrastructure Plan', 'tronixcore'),
                    ],
                    [
                        'sercvice_info_list' => esc_html__('Plan IT Consultant', 'tronixcore'),
                    ],
                ],
                'title_field' => '{{{ sercvice_info_list }}}',
                'condition' => [
                    'enable_service_info' => 'yes',
                ],
            ]
        );
        $this->add_responsive_control(
            'tronix_footer_justify_page2',
            [
                'label' => esc_html__('Justify Alignmnet', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'flex-start' => [
                        'title' => esc_html__('Left', 'tronixcore'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'tronixcore'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'flex-end' => [
                        'title' => esc_html__('Right', 'tronixcore'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .footer-justify2' => 'justify-content: {{VALUE}};',
                ],
                'condition' => [
                    'enable_service_info' => 'yes',
                ],
            ]
        );
        $this->end_controls_section();


        $this->start_controls_section(
            'blog_section',
            [
                'label' => esc_html__('Recent Post', 'tronixcore'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'edit_widget_from_appearance!' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'enable_blog',
            [
                'label' => esc_html__('Enable Blog', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'tronixcore'),
                'label_off' => esc_html__('Hide', 'tronixcore'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'blog_title',
            [
                'label' => esc_html__('Title', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Popular Posts', 'tronixcore'),
                'condition' => [
                    'enable_blog' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'title_lanth',
            [
                'label'   => esc_html__('Title Lanth ', 'tronixcore'),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'min'     => 1,
                'max'     => 20,
                'step'    => 1,
                'default' => 3,
                'condition' => [
                    'enable_blog' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'item_show',
            [
                'label'   => esc_html__('Display Item', 'tronixcore'),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'min'     => 1,
                'max'     => 100,
                'step'    => 1,
                'default' => 2,
                'condition' => [
                    'enable_blog' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'order',
            [
                'label'   => esc_html__('Order By', 'tronixcore'),
                'type'    => \Elementor\Controls_Manager::SELECT,
                'default' => 'ASC',
                'options' => [
                    'ASC'  => esc_html__('ASC', 'tronixcore'),
                    'DESE' => esc_html__('DESE', 'tronixcore'),
                ],
                'condition' => [
                    'enable_blog' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'orderby',
            [
                'label'   => esc_html__('Order by', 'tronixcore'),
                'type'    => Controls_Manager::SELECT,
                'default' => 'none',
                'options' => [
                    'none'          => esc_html__('None', 'tronixcore'),
                    'ID'            => esc_html__('ID', 'tronixcore'),
                    'date'          => esc_html__('Date', 'tronixcore'),
                    'name'          => esc_html__('Name', 'tronixcore'),
                    'title'         => esc_html__('Title', 'tronixcore'),
                    'comment_count' => esc_html__('Comment count', 'tronixcore'),
                    'rand'          => esc_html__('Random', 'tronixcore'),
                ],
                'condition' => [
                    'enable_blog' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'elable_buton',
            [
                'label' => esc_html__('Enable Button', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'tronixcore'),
                'label_off' => esc_html__('Hide', 'tronixcore'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'blog_btn',
            [
                'label' => esc_html__('Button', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Read More', 'tronixcore'),
                'condition' => [
                    'enable_blog' => 'yes',
                    'elable_buton' => 'yes',
                ],
            ]
        );
        $this->end_controls_section();

        // Column Control
        $this->start_controls_section(
            'column_control',
            [
                'label' => esc_html__('Column Control', 'tronixcore'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'desktop_col',
            [
                'label'   => __('Columns On Desktop', 'tronixcore'),
                'type'    => Controls_Manager::SELECT,
                'default' => 'col-xl-3',
                'options' => [
                    'col-xl-12' => __('1 Column', 'tronixcore'),
                    'col-xl-6'  => __('2 Column', 'tronixcore'),
                    'col-xl-4'  => __('3 Column', 'tronixcore'),
                    'col-xl-3'  => __('4 Column', 'tronixcore'),
                    'col-xl-2'  => __('6 Column', 'tronixcore'),
                ],
            ]
        );

        $this->add_control(
            'laptop_col',
            [
                'label'   => __('Columns for Laptop', 'tronixcore'),
                'type'    => Controls_Manager::SELECT,
                'default' => 'col-lg-6',
                'options' => [
                    'col-lg-12' => __('1 Column', 'tronixcore'),
                    'col-lg-6'  => __('2 Column', 'tronixcore'),
                    'col-lg-4'  => __('3 Column', 'tronixcore'),
                    'col-lg-3'  => __('4 Column', 'tronixcore'),
                    'col-lg-2'  => __('6 Column', 'tronixcore'),
                ],
            ]
        );

        $this->add_control(
            'tab_col',
            [
                'label'   => __('Columns On Tablet', 'tronixcore'),
                'type'    => Controls_Manager::SELECT,
                'default' => 'col-md-6',
                'options' => [
                    'col-md-12' => __('1 Column', 'tronixcore'),
                    'col-md-6'  => __('2 Column', 'tronixcore'),
                    'col-md-4'  => __('3 Column', 'tronixcore'),
                    'col-md-3'  => __('4 Column', 'tronixcore'),
                    'col-md-2'  => __('6 Column', 'tronixcore'),
                ],
            ]
        );
        $this->end_controls_section();

        // CopyRight Section
        $this->start_controls_section(
            'copyright_section',
            [
                'label' => esc_html__('CopyRight Section', 'tronixcore'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );


        $this->add_control(
            'copyright_content',
            [
                'label' => esc_html__('Copyright Content', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'default' => __('© Copyright 2024 tronix All Rights Reserved <a href="https://themepul.com">Themepul</a>', 'tronixcore'),
            ]
        );

        $this->add_control(
            'footer_menu_options',
            [
                'label' => esc_html__('Menu List', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'enable_copyright_footer_menu',
            [
                'label' => esc_html__('Enable Copyright', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'tronixcore'),
                'label_off' => esc_html__('Hide', 'tronixcore'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'copyright_footer_menu',
            [
                'label' => esc_html__('Title', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block'   => true,
            ]
        );
        $repeater->add_control(
            'copyright_footer_menu_link',
            [
                'label' => esc_html__('Link', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'tronixcore'),
                'options' => ['url', 'is_external', 'nofollow'],
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );

        $this->add_control(
            'copyright_footer_menu_list',
            [
                'label'   => esc_html__('Contact List', 'tronixcore'),
                'type'    => \Elementor\Controls_Manager::REPEATER,
                'fields'  => $repeater->get_controls(),
                'default' => [
                    [
                        'copyright_footer_menu' => esc_html__('Trams & Condition', 'tronixcore'),
                    ],
                    [
                        'copyright_footer_menu' => esc_html__('Privacy Policy', 'tronixcore'),
                    ],
                ],
                'title_field' => '{{{ copyright_footer_menu }}}',
                'condition' => [
                    'enable_copyright_footer_menu' => 'yes',
                ],
            ]
        );
        $this->end_controls_section();

        // Box Section CSS
        $this->start_controls_section(
            'box_css_options',
            [
                'label' => esc_html__('Box Style', 'tronixcore'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'main_box_bg',
                'types' => ['classic', 'gradient', 'video'],
                'selector' => '{{WRAPPER}} .footer-template-five',
            ]
        );

        $this->add_responsive_control(
            'main_box_padding',
            [
                'label' => esc_html__('Padding', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .footer-v5-widget-area' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'main_box_margin',
            [
                'label' => esc_html__('Margin', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .footer-v5-widget-area' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'footer_top_box_css',
            [
                'label' => esc_html__('Footer Top Style', 'tronixcore'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'enable_footer_top' => 'yes',
                ],
            ]
        );
        $this->add_responsive_control(
            'top_inner_box_border_color',
            [
                'label'     => esc_html__('Border Color', 'tronixcore'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer-v5-coloum' => 'border-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'top_inner_box_margin',
            [
                'label'      => esc_html__('Margin', 'tronixcore'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .footer-v5-top-info' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'top_inner_box_padding',
            [
                'label'      => esc_html__('Padding', 'tronixcore'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .footer-v5-top-info' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs(
            'icon_tabs'
        );
        $this->start_controls_tab(
            'box_box_style',
            [
                'label' => __('Box', 'tronixcore'),
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name'     => 'footer_top_box_bg',
                'label'    => esc_html__('Background', 'tronixcore'),
                'types'    => ['classic', 'gradient', 'video'],
                'selector' => '{{WRAPPER}} .footer-v5-top-area',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'footer_top_box_border',
                'label' => esc_html__('Border', 'tronixcore'),
                'selector' => '{{WRAPPER}} .footer-v5-top-area',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'footer_top_box_shadow',
                'label' => esc_html__('Box Shadow', 'tronixcore'),
                'selector' => '{{WRAPPER}} .footer-v5-top-area',
            ]
        );
        $this->add_responsive_control(
            'footer_top_box_border_radius',
            [
                'label'      => esc_html__('Border Radius', 'tronixcore'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .footer-v5-top-area' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'footer_top_box_margin',
            [
                'label'      => esc_html__('Margin', 'tronixcore'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .footer-v5-top-area' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'footer_top_box_padding',
            [
                'label'      => esc_html__('Padding', 'tronixcore'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .footer-v5-top-area' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'icon_box_normal',
            [
                'label' => __('Icon', 'tronixcore'),
            ]
        );
        $this->add_responsive_control(
            'icon-positon',
            [
                'label'     => __('Alignment', 'tronixcore'),
                'type'      => \Elementor\Controls_Manager::CHOOSE,
                'options'   => [
                    'flex-start'   => [
                        'title' => __('Start', 'tronixcore'),
                        'icon'  => 'eicon-align-start-v',
                    ],
                    'center' => [
                        'title' => __('Center', 'tronixcore'),
                        'icon'  => 'eicon-align-center-h',
                    ],
                    'flex-end'  => [
                        'title' => __('End', 'tronixcore'),
                        'icon'  => 'eicon-align-end-v',
                    ],
                ],
                'default'   => 'center',
                'toggle'    => true,
                'selectors' => [
                    '{{WRAPPER}} .footer-v5-top-info' => 'align-items: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'header_top_icon_size',
                'label' => __('Typography', 'tronixcore'),
                'selector' => '{{WRAPPER}} .footer-v5-top-icon',
            ]
        );
        $this->add_responsive_control(
            'icon_width',
            [
                'label'      => esc_html__('Width', 'tronixcore'),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 300,
                        'step' => 1,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .footer-v5-top-icon' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'min_icon_width',
            [
                'label'      => esc_html__('Min Width', 'tronixcore'),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 300,
                        'step' => 1,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .footer-v5-top-icon' => 'min-width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'icon_height',
            [
                'label'      => esc_html__('Height', 'tronixcore'),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 300,
                        'step' => 1,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .footer-v5-top-icon' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'icon_color',
            [
                'label'     => esc_html__('Color', 'tronixcore'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer-v5-top-icon' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name'     => 'icon_bg',
                'label'    => esc_html__('Background', 'tronixcore'),
                'types'    => ['classic', 'gradient', 'video'],
                'selector' => '{{WRAPPER}} .footer-v5-top-icon',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_box_Shadow::get_type(),
            [
                'name'     => 'icon_shadow',
                'label'    => esc_html__('icon Shadow', 'tronixcore'),
                'selector' => '{{WRAPPER}} .footer-v5-top-icon',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'icon_border',
                'label'    => esc_html__('Border', 'tronixcore'),
                'selector' => '{{WRAPPER}} .footer-v5-top-icon',
            ]
        );
        $this->add_responsive_control(
            'icon_radius',
            [
                'label'      => esc_html__('Border Radius', 'tronixcore'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .footer-v5-top-icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'icon_margin',
            [
                'label'      => esc_html__('Margin', 'tronixcore'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .footer-v5-top-icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'icon_padding',
            [
                'label'      => esc_html__('Padding', 'tronixcore'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .footer-v5-top-icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'svg_size_note',
            [
                'label' => __('SVG Icon Size', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_responsive_control(
            'icon_svg_width',
            [
                'label' => esc_html__('SVG With', 'tronixcore'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 300,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .footer-v5-top-icon svg' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'icon_svg_height',
            [
                'label' => esc_html__('SVG Height', 'tronixcore'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 300,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .footer-v5-top-icon svg' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();

        $this->start_controls_tab(
            'icon_box_title_tab',
            [
                'label' => esc_html__('Label', 'tronixcore'),
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'icon_box_title_typo',
                'label' => __('Typography', 'tronixcore'),
                'selector' => '{{WRAPPER}} .footer-v5-top-lavel',
            ]
        );
        $this->add_responsive_control(
            'icon_box_title_color',
            [
                'label'       => esc_html__('Color', 'tronixcore'),
                'type'        => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer-v5-top-lavel' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_box_title_margin',
            [
                'label'      => esc_html__('Margin', 'tronixcore'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .footer-v5-top-lavel' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'icon_box_title_padding',
            [
                'label'      => esc_html__('Padding', 'tronixcore'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .footer-v5-top-lavel' => 'Padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();

        $this->start_controls_tab(
            'icon_box_des_tab',
            [
                'label' => esc_html__('Content ', 'tronixcore'),
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'icon_box_des_typo',
                'label' => esc_html__('Typography', 'tronixcore'),
                'selector' => '{{WRAPPER}} .footer-v5-top-title',
            ]
        );
        $this->add_responsive_control(
            'icon_box_des_color',
            [
                'label' => esc_html__('Color', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer-v5-top-title' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .footer-v5-top-title a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'icon_box_des_color_hover',
            [
                'label' => esc_html__('Hover Color', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer-v5-top-title a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'icon_box_des_margin',
            [
                'label' => esc_html__('Margin', 'tronixcore'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .footer-v5-top-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'icon_box_des_padding',
            [
                'label' => esc_html__('Padding', 'tronixcore'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .footer-v5-top-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
        // COMPANY SECTION CSS
        $this->start_controls_section(
            'widget_title_section',
            [
                'label' => esc_html__('Widget Title Style', 'tronixcore'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'widget_title_typo',
                'selector' => '{{WRAPPER}} .footer-template-five .footer-v5-widget-title',
            ]
        );

        $this->add_responsive_control(
            'widget_title_color',
            [
                'label' => esc_html__('Text Color', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer-template-five .footer-v5-widget-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'widget_title_border_color',
            [
                'label' => esc_html__('Border Color', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer-template-five .footer-v5-widget-title:after' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .footer-template-five .footer-v5-widget-title:before' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'widget_title_margin',
            [
                'label' => esc_html__('Margin', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .footer-template-five .footer-v5-widget-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'widget_title_padding',
            [
                'label' => esc_html__('Padding', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .footer-template-five .footer-v5-widget-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
        $this->start_controls_section(
            'company_css_options',
            [
                'label' => esc_html__('Company Section', 'tronixcore'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'company_align',
            [
                'label' => esc_html__('Alignment', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'tronixcore'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'tronixcore'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'tronixcore'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'left',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .footer-v5-about-widget' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'company_box_padding',
            [
                'label' => esc_html__('Padding', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .footer-v5-about-widget' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'company_box_margin',
            [
                'label' => esc_html__('Margin', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .footer-v5-about-widget' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs(
            'company_css_tabs'
        );

        // content
        $this->start_controls_tab(
            'company_css_dec_tab',
            [
                'label' => esc_html__('Content', 'tronixcore'),
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'company_dec_typo',
                'selector' => '{{WRAPPER}} .footer-v5-about-des',
            ]
        );

        $this->add_responsive_control(
            'company_dec_color',
            [
                'label' => esc_html__('Color', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer-v5-about-des' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'company_dec_margin',
            [
                'label' => esc_html__('Margin', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .footer-v5-about-des' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'company_dec_padding',
            [
                'label' => esc_html__('Padding', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .footer-v5-about-des' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();

        // Info
        $this->start_controls_tab(
            'company_css_info_tab',
            [
                'label' => esc_html__('Social  Icon', 'tronixcore'),
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'company_info_icon_typo',
                'selector' => '{{WRAPPER}} .footer-one-social-widget ul li a',
            ]
        );
        $this->add_responsive_control(
            'company_info_icon_color',
            [
                'label' => esc_html__('icon Color', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer-one-social-widget ul li a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'company_info_icon_bg',
                'types' => ['classic', 'gradient', 'video'],
                'selector' => '{{WRAPPER}} .footer-one-social-widget ul li a',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'company_info_icon_border',
                'label' => esc_html__('Border', 'tronixcore'),
                'selector' => '{{WRAPPER}} .company-info-widget ul li a',
            ]
        );
        $this->add_responsive_control(
            'company_info_icon_radius',
            [
                'label' => esc_html__('Border Radius', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .footer-one-social-widget ul li a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'company_social_icon_shadow',
                'label' => esc_html__('Box Shadow', 'tronixcore'),
                'selector' => '{{WRAPPER}} .footer-one-social-widget ul li a',
            ]
        );
        $this->add_responsive_control(
            'company_info_icon_margin',
            [
                'label' => esc_html__('Margin', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .footer-one-social-widget ul li a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'company_info_icon_padding',
            [
                'label' => esc_html__('Padding', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .footer-one-social-widget ul li a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'company_info_list_note',
            [
                'label' => esc_html__('Hover Style ', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'company_social_icon_typo_hover',
                'selector' => '{{WRAPPER}} .footer-one-social-widget ul li a:hover',
            ]
        );
        $this->add_responsive_control(
            'company_social_icon_c_hover',
            [
                'label' => esc_html__('Color', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer-one-social-widget ul li a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'company_social_icon_bg_hover',
                'types' => ['classic', 'gradient', 'video'],
                'selector' => '{{WRAPPER}} .footer-one-social-widget ul li a:hover',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'company_social_icon_border_hover',
                'label' => esc_html__('Border', 'tronixcore'),
                'selector' => '{{WRAPPER}} .footer-one-social-widget ul li a:hover',
            ]
        );
        $this->add_responsive_control(
            'company_social_icon_radius_hover',
            [
                'label' => esc_html__('Border Radius', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .footer-one-social-widget ul li a:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'company_social_icon_shadow_hover',
                'label' => esc_html__('Box Shadow', 'tronixcore'),
                'selector' => '{{WRAPPER}} .footer-one-social-widget ul li a:hover',
            ]
        );
        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        // Page List Section 
        $this->start_controls_section(
            'page_link_css_options',
            [
                'label' => esc_html__('Quick Link Section', 'tronixcore'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );



        $this->add_responsive_control(
            'page_link_margin',
            [
                'label' => esc_html__('Margin', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .footer-page-quick-link' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'page_link_padding',
            [
                'label' => esc_html__('Padding', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .footer-page-quick-link' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs(
            'page_link_css_tabs'
        );

        $this->start_controls_tab(
            'quick_list_style',
            [
                'label' => esc_html__('Content', 'tronixcore'),
            ]
        );
        $this->add_responsive_control(
            'quick_icon_gap',
            [
                'label' => esc_html__('Icon Gap', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .footer-page-quick-link ul li a i' => 'margin-right: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'page_link_item_typo',
                'selector' => '{{WRAPPER}} .footer-page-quick-link ul li a',
            ]
        );
        $this->add_responsive_control(
            'page_link_item_color',
            [
                'label' => esc_html__('Color', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer-page-quick-link ul li a' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'page_link_item_hcolor',
            [
                'label' => esc_html__('Hover Color', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer-page-quick-link ul li a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'page_link_item_margin',
            [
                'label' => esc_html__('Margin', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .footer-page-quick-link ul li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'page_link_item_padding',
            [
                'label' => esc_html__('Padding', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .footer-page-quick-link ul li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        // Page List Section 
        $this->start_controls_section(
            'contact_info_css_options',
            [
                'label' => esc_html__('Service Section', 'tronixcore'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'contact_info_margin',
            [
                'label' => esc_html__('Margin', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .service-page-quick-link' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'contact_info_padding',
            [
                'label' => esc_html__('Padding', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .service-page-quick-link' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs(
            'contact_info_css_tabs'
        );
        $this->start_controls_tab(
            'contact_info_css_item',
            [
                'label' => esc_html__('Content', 'tronixcore'),
            ]
        );

        $this->add_responsive_control(
            'service_icon_gap',
            [
                'label' => esc_html__('Icon Gap', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .service-page-quick-link ul li a i' => 'margin-right: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'contact_info_icon_color',
            [
                'label' => esc_html__('icon Color', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .contact-widget .service-list-widget ul li i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'contact_info_icon_typo',
                'selector' => '{{WRAPPER}} .contact-widget .service-list-widget ul li i',
            ]
        );

        $this->add_responsive_control(
            'service_link_gap',
            [
                'label' => esc_html__('Gap', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .footer-template-five .service-list-widget ul li i' => 'margin-right: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'contact_info_list_note',
            [
                'label' => esc_html__('Content Options', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'contact_info_dec_typo',
                'selector' => '{{WRAPPER}} .service-page-quick-link ul li a',
            ]
        );

        $this->add_responsive_control(
            'contact_info_dec_color',
            [
                'label' => esc_html__('Color', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-page-quick-link ul li a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'contact_info_dec_color_hover',
            [
                'label' => esc_html__('Hover Color', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-page-quick-link ul li a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'contact_info_dec_margin',
            [
                'label' => esc_html__('Margin', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .service-page-quick-link ul li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'contact_info_dec_padding',
            [
                'label' => esc_html__('Padding', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .service-page-quick-link ul li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        // -----------------
        // ------------------ Recent Post  Widget Style Start ------------=
        // ------------------

        $this->start_controls_section(
            'recent_post_widget',
            [
                'label' => esc_html__('Recent Post Wiget Style', 'tronixcore'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'recent_post_ga[',
            [
                'label' => esc_html__('Gap', 'tronixcore'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .footer-v5-post-thum-widget' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'recent_post_section_title_margin',
            [
                'label'      => esc_html__('Margin', 'tronixcore'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .footer-v5-blog-widget' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'recent_post_section_title_padding',
            [
                'label'      => esc_html__('Padding', 'tronixcore'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .footer-v5-blog-widget' => 'Padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        // Image Tab -----------
        $this->start_controls_tabs(
            'image_style_tabs'
        );

        $this->start_controls_tab(
            'image_normal_tab',
            [
                'label' => esc_html__('Image', 'tronixcore'),
            ]
        );
        $this->add_responsive_control(
            'Image_height',
            [
                'label' => esc_html__('image Height', 'tronixcore'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .footer-v5-blog-img img' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'image_width',
            [
                'label' => esc_html__('Image Width', 'tronixcore'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .footer-v5-blog-img img' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'min_image_width',
            [
                'label' => esc_html__('Min Width', 'tronixcore'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .footer-v5-blog-img img' => 'min-width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'blog_image_object',
            [
                'label'     => esc_html__('Object Fit', 'tronixcore'),
                'type'      => \Elementor\Controls_Manager::SELECT,
                'default'   => 'cover',
                'options'   => [
                    'fill'    => esc_html__('Fill', 'tronixcore'),
                    'contain' => esc_html__('Contain', 'tronixcore'),
                    'cover'   => esc_html__('Cover', 'tronixcore'),
                    'none'    => esc_html__('none', 'tronixcore'),
                ],
                'selectors' => [
                    '{{WRAPPER}} .footer-v5-blog-img img' => 'object-fit: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'image_border_radius',
            [
                'label' => esc_html__('Border Radius', 'tronixcore'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',

                ],
                'selectors' => [
                    '{{WRAPPER}} .footer-v5-blog-img img' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'image_margin',
            [
                'label' => esc_html__('Margin', 'tronixcore'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .footer-v5-blog-img img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'image_padding',
            [
                'label' => esc_html__('Padding', 'tronixcore'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .footer-v5-blog-img img' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'recent_post_title_tab',
            [
                'label' => esc_html__('Title', 'tronixcore'),
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'recent_post_title_typo',
                'label' => __('Typography', 'tronixcore'),
                'selector' => '{{WRAPPER}} .footer-v5-blog-title a',
            ]
        );
        $this->add_responsive_control(
            'recent_post_title_color',
            [
                'label'       => esc_html__('Color', 'tronixcore'),
                'type'        => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer-v5-blog-title a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'recent_post_title_color_hover',
            [
                'label'       => esc_html__('Hover Color', 'tronixcore'),
                'type'        => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer-v5-blog-title a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'recent_post_title_margin',
            [
                'label'      => esc_html__('Margin', 'tronixcore'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .footer-v5-blog-title a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'recent_post_title_padding',
            [
                'label'      => esc_html__('Padding', 'tronixcore'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .footer-v5-blog-title a' => 'Padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();

        $this->start_controls_tab(
            'recent_post_date_tab',
            [
                'label' => esc_html__('Date ', 'tronixcore'),
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'date_typo',
                'label' => esc_html__('Typography', 'tronixcore'),
                'selector' => '{{WRAPPER}} .footer-v5-date',
            ]
        );
        $this->add_responsive_control(
            'date_color',
            [
                'label' => esc_html__('Color', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer-v5-date' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'date_margin',
            [
                'label' => esc_html__('Margin', 'tronixcore'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .footer-v5-date' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'date_padding',
            [
                'label' => esc_html__('Padding', 'tronixcore'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .footer-v5-date' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'recent_post_button_tab',
            [
                'label' => esc_html__('Button ', 'tronixcore'),
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'blog_button_typo',
                'label' => esc_html__('Typography', 'tronixcore'),
                'selector' => '{{WRAPPER}} .footer-blog-v5-btn a',
            ]
        );
        $this->add_responsive_control(
            'blog_button_color',
            [
                'label' => esc_html__('Color', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer-blog-v5-btn a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'blog_button_color_hover',
            [
                'label' => esc_html__('Hover Color', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer-blog-v5-btn a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'blog_button_margin',
            [
                'label' => esc_html__('Margin', 'tronixcore'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .footer-blog-v5-btn a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'blog_button_padding',
            [
                'label' => esc_html__('Padding', 'tronixcore'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .footer-blog-v5-btn a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();


        // Copyright CSS Section 
        // 
        // ----------------Copyright Style------------------
        // 

        $this->start_controls_section(
            'Copyright_style_options',
            [
                'label' => esc_html__('Copyright Section', 'tronixcore'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'box_align',
            [
                'label' => esc_html__('Alignment', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'tronixcore'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'tronixcore'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'tronixcore'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .footer-v5-copyright-area' => 'text-align: {{VALUE}};',
                    '{{WRAPPER}} .footer-v5-copyright-area' => 'justify-content: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name'     => 'box_backgrounds',
                'label'    => esc_html__('Background', 'tronixcore'),
                'types'    => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .footer-v5-copyright-area',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'box_border',
                'label'    => esc_html__('Border', 'tronixcore'),
                'selector' => '{{WRAPPER}} .footer-v5-copyright-area',
            ]
        );
        $this->add_responsive_control(
            'box_radius',
            [
                'label'      => esc_html__('Border Radius', 'tronixcore'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .footer-v5-copyright-area' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'box_shadow',
                'label'    => esc_html__('Box Shadow', 'tronixcore'),
                'selector' => '{{WRAPPER}} .footer-v5-copyright-area',
            ]
        );
        $this->add_responsive_control(
            'box_margin',
            [
                'label'      => esc_html__('Margin', 'tronixcore'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .footer-v5-copyright-area' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'box_padding',
            [
                'label'      => esc_html__('Padding', 'tronixcore'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .footer-v5-copyright-area' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs(
            'copyright_section_text_tabs'
        );

        $this->start_controls_tab(
            'copyright_section_text_tab',
            [
                'label' => esc_html__('Copyright Text', 'tronixcore'),
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Copyright_typo',
                'label' => __('Typography', 'tronixcore'),
                'selector' => '{{WRAPPER}} .footer-v5-copyright-text',
            ]
        );
        $this->add_responsive_control(
            'Copyright_color',
            [
                'label'       => esc_html__('Color', 'tronixcore'),
                'type'        => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer-v5-copyright-text' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'Copyright_link_color',
            [
                'label'       => esc_html__('Link Color', 'tronixcore'),
                'type'        => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer-v5-copyright-text a' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'Copyright_link_color_Hover',
            [
                'label'       => esc_html__('Hover Color', 'tronixcore'),
                'type'        => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer-v5-copyright-text a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'Copyright_margin',
            [
                'label'      => esc_html__('Margin', 'tronixcore'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .footer-v5-copyright-text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'Copyright_padding',
            [
                'label'      => esc_html__('Padding', 'tronixcore'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .footer-v5-copyright-text' => 'Padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'copyright_section_menu_tab',
            [
                'label' => esc_html__('Menu Style', 'tronixcore'),
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'copyright_menu_typo',
                'selector' => '{{WRAPPER}} .footer-v5-footer-menu ul li a',
            ]
        );

        $this->add_responsive_control(
            'copyright_menu_color',
            [
                'label' => esc_html__('Color', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer-v5-footer-menu ul li a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'copyright_menu_color_hover',
            [
                'label' => esc_html__('Hover Color', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer-v5-footer-menu ul li a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'copyright_menu_margin',
            [
                'label' => esc_html__('Margin', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .footer-v5-footer-menu ul li a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'copyright_menu_padding',
            [
                'label' => esc_html__('Padding', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .footer-v5-footer-menu ul li a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
    }
    //Render
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $column = $settings['desktop_col'] . ' ' . $settings['laptop_col'] . ' ' . $settings['tab_col'];
        
        $flex = ($settings['enable_footer_logo'] == 'yes') ? 'flex' : '';
?>
        <footer id="colophon" class="site-footer footer-template-five ">
            <?php if ($settings['enable_footer_top'] == 'yes') : ?>
                <div class="container">
                <div class="footer-v5-top-area <?php echo esc_attr($flex); ?>">
                    <?php if ($settings['enable_footer_logo'] == 'yes') : ?>
                            <div class="footer-v5-top-logo">
                                <?php echo wp_get_attachment_image($settings['ft_image']['id'], 'full'); ?>
                            </div>
                        <?php endif; ?>

                        <div class="footer-v5-top-content">
                            <div class="row">
                                <?php foreach ($settings['ft_icon_box_list'] as $icon_list) : ?>
                                    <div class="col-lg-4 col-md-6 col-12 footer-v5-coloum">
                                        <div class="footer-v5-top-info">
                                            <div class="footer-v5-top-icon">
                                                <?php \Elementor\Icons_Manager::render_icon($icon_list['ft_icon'], ['aria-hidden' => 'true']); ?>
                                            </div>
                                            <div class="info">
                                                <?php if (!empty($icon_list['ft_title'])) : ?>
                                                    <div class="footer-v5-top-lavel"><?php echo wp_kses($icon_list['ft_title'], tronix_allowhtml()); ?> </div>
                                                <?php endif; ?>
                                                <div class="footer-v5-top-title"> <?php echo wp_kses($icon_list['ft_des'], tronix_allowhtml()); ?></div>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>

                    </div>
                </div>
            <?php endif ?>
            <div class="footer-v5-widget-area">
                <div class="container">
                    <div class="row">
                        <?php if ($settings['edit_widget_from_appearance'] == 'yes') : ?>
                            <?php if (is_active_sidebar('footer-1')) : ?>
                                <div class="col-xs-12 col-sm-12 <?php echo esc_attr($column); ?>">
                                    <?php dynamic_sidebar('footer-1'); ?>
                                </div><!-- .widget-area -->
                            <?php endif; ?>
                            <?php if (is_active_sidebar('footer-2')) : ?>
                                <div class="col-xs-12 col-sm-12 <?php echo esc_attr($column); ?>">
                                    <?php dynamic_sidebar('footer-2'); ?>
                                </div><!-- .widget-area -->
                            <?php endif; ?>
                            <?php if (is_active_sidebar('footer-3')) : ?>
                                <div class="col-xs-12 col-sm-12 <?php echo esc_attr($column); ?>">
                                    <?php dynamic_sidebar('footer-3'); ?>
                                </div><!-- .widget-area -->
                            <?php endif; ?>
                            <?php if (is_active_sidebar('footer-3')) : ?>
                                <div class="col-xs-12 col-sm-12 <?php echo esc_attr($column); ?>">
                                    <?php dynamic_sidebar('footer-4'); ?>
                                </div><!-- .widget-area -->
                            <?php endif; ?>
                        <?php else : ?>
                            <?php if ($settings['enable_company_info'] == 'yes') : ?>
                                <div class="col-xs-12 col-sm-12 <?php echo esc_attr($column); ?>">
                                    <div class="footer-v5-about-widget widget">
                                        <?php if ($settings['enable_company_logo'] == 'yes') : ?>
                                            <div class="footer-v5-about-logo">
                                                <?php echo wp_get_attachment_image($settings['company_logo']['id'], 'full'); ?>
                                            </div>
                                        <?php else : ?>
                                            <h4 class="footer-v5-widget-title"><?php echo esc_html($settings['company_title']); ?></h4>
                                        <?php endif; ?>

                                        <div class="company-info-widget">
                                            <?php if ($settings['description']) : ?>
                                                <div class="footer-v5-about-des">
                                                    <?php echo wp_kses($settings['description'], tronix_allowhtml()); ?>
                                                </div>
                                            <?php endif; ?>
                                            <div class="footer-one-social-widget footer-v5-social">
                                                <?php if ($settings['socials']) : ?>
                                                    <ul>
                                                        <?php foreach ($settings['socials'] as $social) :
                                                            $url = $social['social_link']['url'];
                                                            $target = $social['social_link']['is_external'] ? ' target="_blank"' : '';
                                                            $nofollow = $social['social_link']['nofollow'] ? ' rel="nofollow"' : '';
                                                        ?>
                                                            <li>
                                                                <a href="<?php echo esc_url($url); ?>" title="<?php echo esc_attr($social['social_label']); ?>" <?php echo esc_attr($target . $nofollow); ?>>
                                                                    <?php \Elementor\Icons_Manager::render_icon($social['social_icon'], ['aria-hidden' => 'true']); ?></a>
                                                            </li>
                                                        <?php endforeach; ?>
                                                    </ul>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>

                            <?php if ($settings['page_enable'] == 'yes') : ?>
                                <div class="col-xs-12 col-sm-12 <?php echo esc_attr($column); ?> footer-justify1">
                                    <div class="widget footer-page-quick-link">
                                        <?php if ($settings['page_link_title']) :  ?>
                                            <h4 class="footer-v5-widget-title"><?php echo esc_html($settings['page_link_title']); ?></h4>
                                        <?php endif; ?>
                                        <ul>
                                            <?php foreach ($settings['links'] as $item) :
                                                $target = $item['page_links']['is_external'] ? ' target="_blank"' : '';
                                                $nofollow = $item['page_links']['nofollow'] ? ' rel="nofollow"' : '';
                                            ?>
                                                <li>

                                                    <a href="<?php echo esc_url($item['page_links']['url']); ?>" <?php echo  $target . $nofollow ?>>
                                                        <?php if (!empty($item['quick_link_icon'])) : ?>
                                                            <?php \Elementor\Icons_Manager::render_icon($item['quick_link_icon'], ['aria-hidden' => 'true']); ?>
                                                        <?php endif; ?>
                                                        <?php echo esc_html($item['page_link_text']); ?>
                                                    </a>
                                                </li>
                                            <?php endforeach; ?>
                                        </ul>
                                    </div>
                                </div>
                            <?php endif; ?>

                            <?php if ($settings['enable_service_info'] == 'yes') : ?>
                                <div class="col-xs-12 col-sm-12 <?php echo esc_attr($column); ?> footer-justify2">
                                    <div class="widget service-page-quick-link">
                                        <?php if ($settings['service_section_title']) :  ?>
                                            <h4 class="footer-v5-widget-title"><?php echo esc_html($settings['service_section_title']); ?></h4>
                                        <?php endif; ?>
                                        <ul>
                                            <?php foreach ($settings['service'] as $item) : ?>
                                                <li>
                                                    <?php $lurl      = $item['button_url']['url'];
                                                    $ltarget   = $item['button_url']['is_external'] ? ' target="_blank"' : '';
                                                    $lnofollow = $item['button_url']['nofollow'] ? ' rel="nofollow"' : '';
                                                    ?>
                                                    <a href="<?php echo esc_url($lurl); ?>" <?php echo $ltarget . $lnofollow; ?>>
                                                        <?php
                                                        if (!empty($item['sercvice_info_icon'])) {
                                                            \Elementor\Icons_Manager::render_icon($item['sercvice_info_icon'], ['aria-hidden' => 'true']);
                                                        }
                                                        ?>
                                                        <?php echo esc_html($item['sercvice_info_list']); ?>
                                                </li></a>
                                            <?php endforeach; ?>
                                        </ul>
                                    </div>
                                </div>
                            <?php endif; ?>

                            <?php if ($settings['enable_blog'] == 'yes') : ?>
                                <div class="col-xs-12 col-sm-12 <?php echo esc_attr($column); ?>">
                                    <div class="widget footer-v5-blog-widget">
                                        <?php if ($settings['blog_title']) :  ?>
                                            <h4 class="footer-v5-widget-title"><?php echo esc_html($settings['blog_title']); ?></h4>
                                        <?php endif; ?>
                                        <ul>
                                            <?php
                                            $p = new \WP_Query(array(
                                                'posts_per_page' =>  $settings['item_show'],
                                                'post_type'      => 'post',
                                                'orderby'        => esc_attr($settings['orderby']),
                                                'order'          => esc_attr($settings['order']),
                                            ));
                                            while ($p->have_posts()) : $p->the_post(); ?>
                                                <li>
                                                    <div class="footer-v5-post-thum-widget">
                                                        <?php if (has_post_thumbnail()) : ?>
                                                            <div class="footer-v5-blog-img"> <?php the_post_thumbnail('full', array('class' => 'img-responsive')); ?> </div>
                                                        <?php endif; ?>
                                                        <div class="footer-post-date-title-wrp">
                                                            <div class="footer-v5-date"><i class="bi bi-clock"></i> <?php echo get_the_date(); ?> </div>
                                                            <div class="footer-v5-blog-title"> <a href="<?php echo the_permalink(); ?>"> <?php echo wp_trim_words(get_the_title(), $settings['title_lanth']); ?> </a> </div>
                                                            <?php if ($settings['elable_buton'] === 'yes') :  ?>
                                                                <div class="footer-blog-v5-btn"> <a href="<?php echo the_permalink(); ?>"><?php echo esc_html($settings['blog_btn']); ?><i aria-hidden="true" class="fas fa-arrow-right"></i> </a></div>
                                                            <?php endif; ?>
                                                        </div>
                                                    </div>
                                                </li>
                                            <?php endwhile; ?>
                                        </ul>
                                    </div>
                                </div>
                            <?php endif; ?>
                    </div>
                </div>
            </div>

            <div class="container">
                <div class="footer-v5-copyright-area">
                    <div class="footer-v5-copyright-text"> <?php echo wp_kses($settings['copyright_content'], tronix_allowhtml()); ?></div>
                    <?php if ($settings['enable_copyright_footer_menu'] === 'yes') :  ?>
                        <div class="footer-v5-footer-menu">
                            <ul>
                                <?php foreach ($settings['copyright_footer_menu_list'] as $footer_list) :
                                    $url      = $footer_list['copyright_footer_menu_link']['url'];
                                    $target   = $footer_list['copyright_footer_menu_link']['is_external'] ? ' target="_blank"' : '';
                                    $nofollow = $footer_list['copyright_footer_menu_link']['nofollow'] ? ' rel="nofollow"' : '';
                                ?>
                                    <li>
                                        <a href="<?php echo esc_url($url); ?>" <?php echo $target . $nofollow; ?>>
                                            <?php echo esc_html($footer_list['copyright_footer_menu'],); ?>
                                        </a>
                                    </li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

        <?php endif; ?>
        </footer>
<?php
    }
}
Plugin::instance()->widgets_manager->register(new tronix_footer_template_five);
