<?php
if (class_exists('CSF')) {
    function Tronix_inline_style() {
        wp_enqueue_style('tronix-inline', get_template_directory_uri() . '/assets/css/inline-style.css', array(), TRONIX_VERSION , 'all');
        $Tronix_inline = '';
		$Tronix_css_editor = Tronix_options('Tronix_css_editor');
		if (!empty($Tronix_css_editor)) {
			$Tronix_inline .= esc_attr($Tronix_css_editor);
		}
		
		if (1 == Tronix_options('breadcrumb_shape_enable')) {
			$Tronix_inline .= '
				.breadcroumb-area:before, .breadcroumb-area:after {
					content: "";
				}
			';
		} else {
			$Tronix_inline .= '
				.breadcroumb-area:before, .breadcroumb-area:after {
					content: none;
				}
			';
		}
		
		if( !empty( Tronix_options('Tronix_breadcrumb_align', 'center') ) ){
		    $Tronix_inline .= '
    			.breadcroumn-contnt {
    				text-align: '. esc_attr(Tronix_options('Tronix_breadcrumb_align', 'center')) .';
    			}
    		';
		}
		

		// Color Function
		$primary_color = Tronix_options('theme_primary_color');
		$secondary_color = Tronix_options('theme_secondary_color');
		$theme_border_color = Tronix_options('theme_border_color');

		if ( true == Tronix_options('enable_theme_primary_color', false)) {
			if( !empty( $primary_color )  ){
				$Tronix_inline .= '
                :root {
					--thm-color: '.esc_attr($primary_color).';
					} 
				';
				$Tronix_inline .= '
					{
						background-color: var(--thm-color);
						color: var(--thm-color);
						border-color: var(--thm-color);
					} 
				';
			}
        }

		if ( true == Tronix_options('enable_theme_secondary_color', false)) {
			if( !empty( $secondary_color )  ){
				$Tronix_inline .= '
                :root {
					--black-color: '.esc_attr($secondary_color).';
					} 
				';
				$Tronix_inline .= '
					{
						background-color: var(--black-color);
						color: var(--black-color);
						border-color: var(--black-color);
					} 
				';
			}
        }
		
		if ( true == Tronix_options('enable_theme_border_color', false)) {
			if( !empty( $theme_border_color )  ){
				$Tronix_inline .= '
                :root {
						--border-color: '.esc_attr($theme_border_color).';
					} 
				';
				$Tronix_inline .= '
					{
						background-color: var(--border-color);
						color: var(--border-color);
						border-color: var(--border-color);
					} 
				';
			}
        }

		wp_add_inline_style('tronix-inline', $Tronix_inline);
		
    }
}
add_action('wp_enqueue_scripts', 'Tronix_inline_style', 12);