<?php

function tronixcore_import_files() {
    return array(
        array(
            'import_file_name'           => esc_html__( 'Default Demos', 'tronixcore' ),
            'import_file_url'            => plugin_dir_url( __FILE__ ) . 'demo/default/demo.xml',
            'import_widget_file_url'     => plugin_dir_url( __FILE__ ) . 'demo/default/widgets.wie',
            'import_customizer_file_url' => plugin_dir_url( __FILE__ ) . 'demo/default/customizer.dat',
            'local_import_json'          => array(
                array(
                    'file_path'   => plugin_dir_url( __FILE__ ) . 'demo/default/theme-options.json',
                    'option_name' => 'Tronix_Theme_Option',
                ),
            ),
            'import_preview_image_url'   => 'https://intro.themepul.com/tronix/default-demo.jpg',
			'import_notice'              => esc_html__( 'This is Tronix Default Demo', 'tronixcore' ),
            'preview_url'                => 'https://wptf.themepul.co/tronix',
        ),
        array(
            'import_file_name'           => esc_html__( 'RTL Demos', 'tronixcore' ),
            'import_file_url'            => plugin_dir_url( __FILE__ ) . 'demo/rtl/demo.xml',
            'import_widget_file_url'     => plugin_dir_url( __FILE__ ) . 'demo/rtl/widgets.wie',
            'import_customizer_file_url' => plugin_dir_url( __FILE__ ) . 'demo/rtl/customizer.dat',
            'local_import_json'          => array(
                array(
                    'file_path'   => plugin_dir_url( __FILE__ ) . 'demo/rtl/theme-options.json',
                    'option_name' => 'Tronix_Theme_Option',
                ),
            ),
            'import_preview_image_url'   => 'https://intro.themepul.com/tronix/rtl-demo.jpg',
			'import_notice'              => esc_html__( 'This is Tronix RTL Demo', 'tronixcore' ),
            'preview_url'                => 'https://wptf.themepul.co/tronix-rtl',
        ),
    );
}
add_filter( 'ocdi/import_files', 'tronixcore_import_files' );

function tronixcore_after_import_setup() {
    // Assign menus to their locations.
    $main_menu = get_term_by( 'name', 'Main Menu', 'nav_menu' );

    set_theme_mod( 'nav_menu_locations', array(
        'mainmenu' => $main_menu->term_id, // replace 'main-menu' here with the menu location identifier from register_nav_menu() function
    )
    );
    // Assign front page and posts page (blog page).
    $front_page_id = get_page_by_title( 'Home' );
    $blog_page_id = get_page_by_title( 'Blog' );

    update_option( 'show_on_front', 'page' );
    update_option( 'page_on_front', $front_page_id->ID );
    update_option( 'page_for_posts', $blog_page_id->ID );

}
add_action( 'ocdi/after_import', 'tronixcore_after_import_setup' );