<?php

namespace Elementor;

class services_one_widget extends Widget_Base
{

    public function get_name()
    {

        return 'tronix_services_one';
    }

    public function get_title()
    {
        return esc_html__('Tronix Service V1', 'tronixcore');
    }

    public function get_icon()
    {

        return 'eicon-shape';
    }

    public function get_categories()
    {
        return ['tronixcore'];
    }

    protected function register_controls()
    {
        //Content tab start

        $this->start_controls_section(
            'tronix_service_content',
            [
                'label' => esc_html__('Tronix Service V1', 'tronixcore'),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'select_style',
            [
                'label' => esc_html__('Select Style', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'one',
                'options' => [
                    'one' => esc_html__('One', 'tronixcore'),
                    'two'  => esc_html__('Two', 'tronixcore'),
                ],
            ]
        );
        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'icon',
            [
                'label'   => esc_html__('Icon', 'tronixcore'),
                'type'    => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value'   => 'fas fa-university',
                    'library' => 'fa-solid',
                ],
            ]
        );
        $repeater->add_control(
            'title',
            [
                'label'       => esc_html__('Title', 'tronixcore'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__('IT Management Service', 'tronixcore'),
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'enable_title_link',
            [
                'label' => esc_html__('Enable Title Link', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'tronixcore'),
                'label_off' => esc_html__('Hide', 'tronixcore'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $repeater->add_control(
            'title_link',
            [
                'label'       => esc_html__('Title Link', 'tronixcore'),
                'type'        => \Elementor\Controls_Manager::URL,
                'options'     => ['url', 'is_external', 'nofollow'],
                'label_block' => true,
                'condition' => [
                    'enable_title_link' => 'yes',
                ],
                'default'     => [
                    'url'         => '',
                    'is_external' => true,
                    'nofollow'    => true,
                ],
            ]
        );

        $repeater->add_control(
            'description',
            [
                'label'       => esc_html__('Description', 'tronixcore'),
                'type'        => \Elementor\Controls_Manager::TEXTAREA,
                'default'     => esc_html__('Developing a comprehensive IT strategy that aligns.', 'tronixcore'),
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'enable_button',
            [
                'label' => esc_html__('Enable Button', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'tronixcore'),
                'label_off' => esc_html__('Hide', 'tronixcore'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $repeater->add_control(
            'btn_icon',
            [
                'label'   => esc_html__('Botton Icon', 'tronixcore'),
                'type'    => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value'   => 'bi bi-arrow-right-short',
                    'library' => 'fa-solid',
                ],
                'condition'     => [
                    'enable_button' => 'yes',
                ],
            ]
        );
        $repeater->add_control(
            'btn_text',
            [
                'label'       => esc_html__('Button Text', 'tronixcore'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__('Read More', 'tronixcore'),
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'link',
            [
                'label'         => __('Link', 'tronixcore'),
                'type'          => \Elementor\Controls_Manager::URL,
                'placeholder'   => __('httronixs://your-link.com', 'tronixcore'),
                'show_external' => true,
                'default'       => [
                    'url'         => '',
                    'is_external' => true,
                    'nofollow'    => true,
                ],
                'dynamic'       => [
                    'active' => true,
                ],
                'condition'     => [
                    'enable_button' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'tronix_repeater_list',
            [
                'label'       => esc_html__('Repeater List', 'tronixcore'),
                'type'        => \Elementor\Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'default' => [
                    [
                        'title' => esc_html__('Technology Solution', 'tronixcore'),
                        'description' => esc_html__('Risus turpis id mauris tellus ultricies cras nulla.', 'tronixcore'),
                    ],
                    [
                        'title' => esc_html__('IT Management Service', 'tronixcore'),
                        'description' => esc_html__('Developing a comprehensive IT strategy that aligns.', 'tronixcore'),
                    ],
                    [
                        'title' => esc_html__('Website & Mobile App', 'tronixcore'),
                        'description' => esc_html__('Website and mobile apps design are critical.', 'tronixcore'),
                    ],
                    [
                        'title' => esc_html__('Data Tracking Security', 'tronixcore'),
                        'description' => esc_html__('Encryption is a method of converting sensitive', 'tronixcore'),
                    ],
                ],
                'title_field' => '{{{ title }}}',
            ]
        );
        $this->add_control(
            'service_more_options',
            [
                'label' => esc_html__('Necessary Options', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'enable_container',
            [
                'label' => esc_html__('Enable Container', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'tronixcore'),
                'label_off' => esc_html__('Hide', 'tronixcore'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_responsive_control(
            'desktop_col',
            [
                'label' => esc_html__('Columns On Desktop', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'col-xl-3',
                'options' => [
                    'col-xl-12'  => esc_html__('1 Column', 'tronixcore'),
                    'col-xl-6'  => esc_html__('2 Column', 'tronixcore'),
                    'col-xl-4'  => esc_html__('3 Column', 'tronixcore'),
                    'col-xl-3'  => esc_html__('4 Column', 'tronixcore'),
                ],
            ]
        );
        $this->add_responsive_control(
            'ipadpro_col',
            [
                'label' => esc_html__('Columns On Ipad Pro', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'col-lg-6',
                'options' => [
                    'col-lg-12'  => esc_html__('1 Column', 'tronixcore'),
                    'col-lg-6'  => esc_html__('2 Column', 'tronixcore'),
                    'col-lg-4'  => esc_html__('3 Column', 'tronixcore'),
                    'col-lg-3'  => esc_html__('4 Column', 'tronixcore'),
                ],
            ]
        );
        $this->add_responsive_control(
            'tab_col',
            [
                'label' => esc_html__('Columns On Tablet', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'col-md-6',
                'options' => [
                    'col-md-12'  => esc_html__('1 Column', 'tronixcore'),
                    'col-md-6'  => esc_html__('2 Column', 'tronixcore'),
                    'col-md-4'  => esc_html__('3 Column', 'tronixcore'),
                    'col-md-3'  => esc_html__('4 Column', 'tronixcore'),
                ],
            ]
        );
        $this->end_controls_section();

        //========================================//
        //========= SERVICE BOX style Start==========//
        //========================================//

        $this->start_controls_section(
            'services_box',
            [
                'label' => esc_html__('Content Box', 'tronixcore'),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs(
            'services_section_tabs'
        );
        $this->start_controls_tab(
            'services_section_normal_tab',
            [
                'label' => esc_html__('Normal', 'tronixcore'),
            ]
        );
        $this->add_responsive_control(
            'height',
            [
                'label' => esc_html__( 'Height', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 600,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .service-box' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'box_align',
            [
                'label' => esc_html__('Alignment', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'tronixcore'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'tronixcore'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'tronixcore'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .service-box' => 'text-align: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name'     => 'box_backgrounds',
                'label'    => esc_html__('Background', 'tronixcore'),
                'types'    => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .service-box',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'box_border',
                'label'    => esc_html__('Border', 'tronixcore'),
                'selector' => '{{WRAPPER}} .service-box',
            ]
        );
        $this->add_responsive_control(
            'services_border_radius',
            [
                'label'      => esc_html__('Border Radius', 'tronixcore'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .service-box' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'box_shadow',
                'label'    => esc_html__('Box Shadow', 'tronixcore'),
                'selector' => '{{WRAPPER}} .service-box',
            ]
        );
        $this->add_responsive_control(
            'box_margin',
            [
                'label'      => esc_html__('Margin', 'tronixcore'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .service-box' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'box_padding',
            [
                'label'      => esc_html__('Padding', 'tronixcore'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .service-box' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'box_hover_tab',
            [
                'label' => esc_html__('Hover', 'tronixcore'),
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name'     => 'box_backgrounds_hover',
                'label'    => esc_html__('Background', 'tronixcore'),
                'types'    => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .service-box:hover',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'box_shadow_hover',
                'label'    => esc_html__('Box Shadow', 'tronixcore'),
                'selector' => '{{WRAPPER}} .service-box:hover',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'box_border_hover',
                'label'    => esc_html__('Border', 'tronixcore'),
                'selector' => '{{WRAPPER}} .service-box:hover',
            ]
        );

        $this->add_responsive_control(
            'border_radius_hover',
            [
                'label'      => esc_html__('Border Radius', 'tronixcore'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .service-box:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        //========================================//
        //======= SERVICE ICON STYLE START=====//
        //========================================//
        $this->start_controls_section(
            'icon_Style',
            [
                'label' => esc_html__('Icon Style', 'tronixcore'),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'icon_width',
            [
                'label' => esc_html__('Width', 'tronixcore'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 20,
                        'max' => 200,
                        'step' => 1,
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .service-one-icon' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'icon_height',
            [
                'label' => esc_html__('Height', 'tronixcore'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 20,
                        'max' => 200,
                        'step' => 1,
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .service-one-icon' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'icon_typo',
                'selector' => '{{WRAPPER}} .service-one-icon',
            ]
        );
        $this->add_responsive_control(
            'services_icon_color',
            [
                'label'     => esc_html__('Icon Color', 'tronixcore'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-one-icon' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'services_icon_color_hover',
            [
                'label'     => esc_html__('Icon Hover Color', 'tronixcore'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-box:hover .service-one-icon' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name'     => 'icon_bg',
                'label'    => esc_html__('Icon Background', 'tronixcore'),
                'types'    => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .service-one-icon',
            ]
        );
        $this->add_control(
            'more_options',
            [
                'label' => esc_html__('Backgroun Hover Color', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name'     => 'icon_bg_hover',
                'label'    => esc_html__('Icon Background Hover', 'tronixcore'),
                'types'    => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .service-box:hover .service-one-icon',
                'separator' => 'after',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'icon_border',
                'label'    => esc_html__('Border', 'tronixcore'),
                'selector' => '{{WRAPPER}} .service-one-icon',
            ]
        );
        $this->add_responsive_control(
            'icon_border_redius',
            [
                'label'      => esc_html__('Border Redius', 'tronixcore'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .service-one-icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'svg_options',
            [
                'label' => esc_html__('Svg Image Control', 'tronixcore'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_responsive_control(
            'tronix_svg_width',
            [
                'label' => esc_html__('Width', 'tronixcore'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 20,
                        'max' => 200,
                        'step' => 1,
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .service-one-icon svg' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'tronix_svg_height',
            [
                'label' => esc_html__('Height', 'tronixcore'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 20,
                        'max' => 200,
                        'step' => 1,
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .service-one-icon svg' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'services_svg_color_hover',
            [
                'label'     => esc_html__('Icon Hover Color', 'tronixcore'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-box:hover .service-one-icon svg path ' => 'fill: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'icon_margin',
            [
                'label'      => esc_html__('Margin', 'tronixcore'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .service-one-icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'icon_padding',
            [
                'label'      => esc_html__('Padding', 'tronixcore'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .service-one-icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        // ===================================================
        // ============== CONTENT STYLE ======================
        // ===================================================

        $this->start_controls_section(
            'services_content',
            [
                'label' => esc_html__('Content Style', 'tronixcore'),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs('tronix_Content_tabs');
        $this->start_controls_tab(  //service section Title style start
            'services_title_normal_tab',
            [
                'label' => esc_html__('Title', 'tronixcore'),
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'title_typography',
                'selector' => '{{WRAPPER}} .service-one-title',
            ]
        );
        $this->add_responsive_control(
            'title_color',
            [
                'label'     => esc_html__('Color', 'tronixcore'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-one-title' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .service-one-title a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'title_color_hover',
            [
                'label'     => esc_html__('Hover Color', 'tronixcore'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-box:hover .service-one-title' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .service-box:hover .service-one-title a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'title_margin',
            [
                'label'      => esc_html__('Margin', 'tronixcore'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .service-one-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'title_padding',
            [
                'label'      => esc_html__('Padding', 'tronixcore'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .service-one-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();
        // ===================== DECRIPTION STYLE====================
        $this->start_controls_tab(
            'service_content_heading',
            [
                'label' => esc_html__('Decription', 'tronixcore'),
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'dec_typography',
                'selector' => '{{WRAPPER}} .services-one-des',
            ]
        );

        $this->add_responsive_control(
            'dec_color',
            [
                'label'     => esc_html__('Title Color', 'tronixcore'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .services-one-des' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'dect_margin',
            [
                'label'      => esc_html__('Margin', 'tronixcore'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .services-one-des' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'dec_padding',
            [
                'label'      => esc_html__('Padding', 'tronixcore'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .services-one-des' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();


        //  =============================================//
        //  ========= BUTTON  STYLE START ========//
        // =============================================//


        $this->start_controls_section(
            'btn_style',
            [
                'label' => esc_html__('Button Style ', 'tronixcore'),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs(
            'btn_tabs'
        );

        $this->start_controls_tab(
            'btn_normal_tab',
            [
                'label' => esc_html__('Normal', 'tronixcore'),
            ]
        );
        $this->add_responsive_control(
            'btn_width',
            [
                'label' => esc_html__('Iocn Width', 'tronixcore'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'custom'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 150,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .service-btns' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'btn_height',
            [
                'label' => esc_html__('Icon Height', 'tronixcore'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'custom'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 150,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .service-btns' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'btn_typo',
                'selector' => '{{WRAPPER}} .service-btns,{{WRAPPER}} .theme-btns.two',
            ]
        );
        $this->add_responsive_control(
            'btn_color',
            [
                'label'     => esc_html__('Color', 'tronixcore'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-btns' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .theme-btns.two' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name'     => 'btn_bg',
                'label'    => esc_html__('Background', 'tronixcore'),
                'types'    => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .service-btns,{{WRAPPER}} .theme-btns.two',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'btn_border',
                'label'    => esc_html__('Border', 'tronixcore'),
                'selector' => '{{WRAPPER}} .service-btns,{{WRAPPER}} .theme-btns.two',
            ]
        );
        $this->add_responsive_control(
            'btn_border_radius',
            [
                'label'      => esc_html__('Border Radius', 'tronixcore'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .service-btns' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .theme-btns.two' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Text_Shadow::get_type(),
            [
                'name'     => 'btn_shadow',
                'label'    => esc_html__('Box Shadow', 'tronixcore'),
                'selector' => '{{WRAPPER}} .service-btns,{{WRAPPER}} .theme-btns.two',
            ]
        );
        $this->add_responsive_control(
            'btn_Margin',
            [
                'label'      => esc_html__('Margin', 'tronixcore'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .service-btns' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .theme-btns.two' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'btn_padding',
            [
                'label'      => esc_html__('Padding', 'tronixcore'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .service-btns' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .theme-btns.two' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'btn_tab_hover',
            [
                'label' => esc_html__('Hover', 'tronixcore'),
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'btn_typo_hover',
                'selector' => '{{WRAPPER}} .service-box:hover .service-btns,{{WRAPPER}} .theme-btns.two:hover',
            ]
        );
        $this->add_responsive_control(
            'btn_color_hover',
            [
                'label'     => esc_html__('Color', 'tronixcore'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-box:hover .service-btns' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .theme-btns.two:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name'     => 'btn_bg_hover',
                'label'    => esc_html__('Background', 'tronixcore'),
                'types'    => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .service-box:hover .service-btns,{{WRAPPER}} .theme-btns.two:hover',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Text_Shadow::get_type(),
            [
                'name'     => 'btn_shadow_hover',
                'label'    => esc_html__('Box Shadow', 'tronixcore'),
                'selector' => '{{WRAPPER}} .service-box:hover .service-btns,{{WRAPPER}} .theme-btns.two:hover',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'btn_border_hover',
                'label'    => esc_html__('Border', 'tronixcore'),
                'selector' => '{{WRAPPER}} .service-box:hover .service-btns,{{WRAPPER}} .theme-btns.two:hover',
            ]
        );
        $this->add_responsive_control(
            'btn_border_radius_hover',
            [
                'label'      => esc_html__('Border Radius', 'tronixcore'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .service-box:hover .service-btns' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .theme-btns.two:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
    }
    //Render
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $column = $settings['desktop_col'] . ' ' . $settings['ipadpro_col'] . ' ' . $settings['tab_col'];
        $container = ($settings['enable_container'] == 'yes') ? 'container' : 'container-fluid';
        $style2 = ($settings['select_style'] == 'one') ? 'one' : 'two';
        
        ob_start();
?>

        <div class="service-section-wrapper">
            <div class="<?php echo esc_attr($container) ?>">
                <div class="row">
                    <?php foreach ($settings['tronix_repeater_list'] as $item) : ?>
                        <div class="<?php echo esc_attr($column); ?>">
                            <div class="service-box <?php echo esc_attr($style2); ?>">
                                <div class="service-one-icon <?php echo esc_attr($style2); ?>">
                                    <?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true']); ?>
                                </div>
                                <div class="service-one-content">
                                    <h5 class="service-one-title">
                                        <?php if ($item['enable_title_link'] == 'yes') :
                                            $url = $item['title_link']['url'];
                                            $target = $item['title_link']['is_external'] ? ' target="_blank"' : '';
                                            $nofollow = $item['title_link']['nofollow'] ? ' rel="nofollow"' : '';
                                        ?>
                                            <a href="<?php echo esc_url($url); ?>" <?php echo $target . $nofollow; ?>>
                                            <?php endif; ?>
                                            <?php echo esc_html($item['title']); ?>
                                            <?php if ($item['enable_title_link'] == 'yes') : ?></a><?php endif; ?>
                                    </h5>
                                    <div class="services-one-des <?php echo esc_attr($style2); ?>">
                                        <?php echo wp_kses($item['description'], tronix_allowhtml() ); ?>
                                    </div>
                                </div>
                                <?php if ($item['enable_button'] == 'yes') :
                                    $burl = $item['link']['url'];
                                    $btarget = $item['link']['is_external'] ? ' target="_blank"' : '';
                                    $bnofollow = $item['link']['nofollow'] ? ' rel="nofollow"' : '';
                                ?>
                                    <div class="service-one-btn">
                                        <?php if ($settings['select_style'] == 'one') : ?>
                                            <a href="<?php echo esc_url($burl); ?>" class="service-btns">
                                                <?php \Elementor\Icons_Manager::render_icon($item['btn_icon'], ['aria-hidden' => 'true']); ?>
                                            </a>
                                        <?php endif; ?>

                                        <?php if ($settings['select_style'] == 'two') : ?>
                                            <a href="<?php echo esc_url($burl); ?>" class="theme-btns <?php echo esc_attr($style2); ?>" <?php echo $btarget . $bnofollow; ?>>
                                                <?php echo esc_html($item['btn_text']) ?>
                                            </a>
                                        <?php endif; ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>

<?php
        echo ob_get_clean();
    }
}

Plugin::instance()->widgets_manager->register(new services_one_widget);