@extends('layouts.guest')

@section('content')
<div class="card">
    <div class="card-body">
    @foreach($shops as $shop)
        <div class="input-group">
        
            <span class="input-group-text" id="">Allocation No:</span>
            <input type="text" value="{{ __($shop->allocation_no ?? 'None') }}" name="allocation_no" class="form-control" readonly>  
        </div>
        
        <div class="input-group">
            <span class="input-group-text" id="">Shop No:</span>
            <input type="text" value="{{ __($shop->shop_no ?? 'None') }}" name="shop_no" class="form-control" readonly>  
        </div>
        <div class="input-group">
            <span class="input-group-text" id="">Block No:</span>
            <input type="text" value="{{ __($shop->block ?? 'None') }}" name="block" class="form-control" readonly>  
        </div>
        <div class="input-group">
            <span class="input-group-text" id="">Market:</span>
            <input type="text" value="{{ __($shop->market ?? 'None') }}" name="market" class="form-control" readonly>  
        </div>
        <div class="input-group">
            <span class="input-group-text" id="">Shop Owner:</span>
            <input type="hidden" value="" id="shop_owner_id" name="shop_owner_id"/>
            <input type="text" value="{{ __($shop->shopOwner ? $shop->shopOwner->name() : 'None') }}" id="shop_owner_name" class="form-control" readonly>  
        </div>
        
        <div class="input-group">
            <span class="input-group-text" id="">Unique Identifier:</span>
            <input type="hidden" value="{{ __($shop->status ?? 'None') }}" id="status" name="status"/>
            <input type="text" value="{{ __($shop->unique_identifier ?? 'None') }}" name="unique_identifier" class="form-control" readonly>  
        </div>

        <div style="margin-top:10px" class="input-group">
            
            <button type="button" class="btn btn-primary print" > Print </button> 
        </div>
    @endforeach
    </div>
</div>
@endsection
<script>
window.addEventListener('load', function() {
    $(".print").on("click", function(){
        window.print();
    })
})
</script>
