@extends('layouts.fieldofficer')
<script src="{{ asset('public/js/qrcode.js') }}" defer></script>
@section('content')
<style>
.input-group{
    margin-bottom: 10px;
}
</style>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">{{ __('Shop Details') }}</div>

                <div class="card-body">
                    @if (session('status'))
                        <div class="alert alert-success" role="alert">
                            {{ session('status') }}
                        </div>
                    @endif
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    <form action="{{ url('shops/'.$shop->id) }}" method="post">
                    @csrf
                        <div class="input-group">
                            <span class="input-group-text" id="inputGroup-sizing-default">Alocation No:</span>
                            <input type="text" value="{{ __($shop->allocation_no ?? 'None') }}" name="allocation_no" class="form-control" placeholder="Enter Allocation No" aria-label="Enter Allocation No">  
                        </div>
                        <div class="input-group">
                            <label class="input-group-text" for="market">Market</label>
                            <select class="form-select form-control" data-market="{{ __($shop->market ?? 'None') }}" name="market" id="market">
                                <option value="">Select Market</option>
                                <option value="Wuse">Wuse</option>
                                <option value="Garki">Garki</option>
                            </select>
                            <script>
                            </script>
                        </div>
                        <div class="input-group">
                            <label class="input-group-text" for="block">Block</label>
                            <select class="form-select form-control" data-block="{{ __($shop->block ?? 'None') }}" name="block" id="block">
                                <option value="">Select Block</option>
                                <option value="A">A</option>
                                <option value="B">B</option>
                                <option value="C">C</option>
                                <option value="D">D</option>
                                <option value="E">E</option>
                            </select>
                        </div>
                        <div class="input-group">
                            <span class="input-group-text" id="">Shop No:</span>
                            <input type="text" value="{{ __($shop->shop_no ?? 'None') }}" name="shop_no" class="form-control" placeholder="Enter Shop No" aria-label="Enter Shop No">  
                        </div>
                        <div class="input-group">
                            <label class="input-group-text" for="block">Status</label>
                            <select class="form-select form-control" data-status="{{ __($shop->status ?? 'None') }}" name="status"id="status"><option value="">Status</option><option value="0">InActive</option><option value="1">Active</option></select> 
                        </div>
                        <div class="input-group">
                            <span class="input-group-text" id="">Shop Owner:</span>
                            <input type="text" value="{{ __($shop->shopOwner ? $shop->shopOwner->name() : 'None') }}" class="form-control" readonly > 
                            <button type="button" data-id="{{ $shop->id ?? '' }}" class="btn btn-outline-secondary assign">{{ __( !$shop->shopowner ? 'Assign' : 'Re-Assign') }}</button> 
                        </div>
                        <div class="input-group">
                            <span class="input-group-text" id="">Unique Identifier:</span>
                            
                            <input type="text" value="{{ __($shop->unique_identifier ?? 'None') }}" name="unique_identifier" class="form-control" readonly>  
                        </div>
                        <div class="form-group">
                        <input type="hidden" name="_method" value="PUT">
                        <button type="submit" class="btn btn-outline-success">Update</button>  
                        </div>
                    </form>
                </div>

            </div>
            
            <div class="card">
                <div class="card-header">{{ __('Shop QR Code') }}</div>

                <div class="card-body">
                    <div id="qrcode" style="margin-bottom:10px"></div>
                    <button type="button" class="btn btn-outline-secondary downloadqr">Download</button>
                </div>
            </div>
            
        </div>
    </div>
</div>
@endsection
<script>
window.addEventListener('load', function() {
    var market = $('#market').attr("data-market");
    $('#market option[value='+market+']').attr('selected','selected');
    var block = $('#block').attr("data-block");
    $('#block option[value='+block+']').attr('selected','selected');
    var status = $('#status').attr("data-status");
    $('#status option[value='+status+']').attr('selected','selected');
    $(".assign").on("click", function(){
        var id = $(this).attr("data-id");
        var url = "{{ url('assignshop/') }}/"+id;
        window.location = url;
    })
    $(".downloadqr").on("click", function(){
        var imgUrl = $('#qrcode').children('img').attr('src');
        var a = document.createElement("a");
        a.href = imgUrl;
        a.setAttribute("download", "ShopQRCode");
        a.click();
        //alert(img);
    })
    var qrcode = new QRCode(document.getElementById("qrcode"), {
                        text: "{{ url('shops/'.$shop->id) }}",
                        width : 100,
                        height : 100
                    });
    })
</script>
