@extends('layouts.admin')

@section('content')
<style>
.input-group{
    margin-bottom: 10px;
}
</style>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">{{ __('Shop Owner Details') }}</div>

                <div class="card-body">
                    @if (session('status'))
                        <div class="alert alert-success" role="alert">
                            {{ session('status') }}
                        </div>
                    @endif
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    <form action="{{ url('shopowners/'.$shopowner->id) }}" method="post" enctype="multipart/form-data">
                    @csrf
                    <div class="form-group">
                            <input type="text" value="{{ __($shopowner->first_name ?? 'None') }}" name="firstname" class="form-control" placeholder="First Name" >  
                        </div>
                        <div class="form-group">
                            <input type="text" value="{{ __($shopowner->last_name ?? 'None') }}" name="lastname" class="form-control" placeholder="Last Name" >  
                        </div>
                        <div class="form-group">
                            <input type="text" value="{{ __($shopowner->phone ?? 'None') }}" name="phone" class="form-control" placeholder="Phone Number" aria-label="Enter Shop No">  
                        </div>
                        <div class="form-group">
                            <input type="file" name="photo" class="form-control" >  
                        </div>
                        <div class="form-group">
                        <input type="hidden" name="_method" value="PUT">
                        <button type="submit" class="btn btn-outline-success">Update</button>  
                        </div>
                    </form>
                </div>

            </div>
            
            
            
        </div>
    </div>
</div>
@endsection

