@extends('layouts.admin')

@section('content')
<style>
.shopowner{
    cursor:hand; 
    background: #fff;
}
.shopowner:hover {background: #f5f5f5;}
.shopowner img{
    width:50px;
    height:50px;
}
</style>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">{{ __('View All Shop Owners/Search For Shop Owners') }}</div>

                <div class="card-body">
                    @if (session('status'))
                        <div class="alert alert-success" role="alert">
                            {{ session('status') }}
                        </div>
                    @endif
                    @if(Session::has('fail'))
                        <div class="alert alert-danger">
                        {{Session::get('fail')}}
                        </div>
                    @endif

                    <div class="row">
                        <div class="col-4">
                            <a href="{{ url('shopowners/create') }}" class="btn btn-outline-success" >Create Shop Owner</a>
                        </div>
                        <div class="col-8">
                            <a href="{{ url('admin-bulkupload') }}" class="btn btn-outline-success" >Bulk Upload</a>
                        </div>
                    </div>
                </div>

            </div>
            
            <div class="card">
                <div class="card-header">{{ __('Search/Filter') }}</div>

                <div class="card-body">
                    <form action="{{ url('/admin-shopowners-search') }}" method="get">
                        <div class="input-group mb-3">
                            <input type="hidden" name="search_by" value="name"/>
                            <input type="text" name="name" class="form-control" placeholder="Enter First Name" aria-label="Enter Allocation No" aria-describedby="button-addon2">
                            <button class="btn btn-outline-success" type="sumbit" id="">Search</button>
                        </div>
                    </form>
                    
                    
                </div>
            </div>
            <div class="card">
                <div class="card-header">{{ __('Result/List') }}</div>

                <div class="card-body">
                    <div class="row" style="background-color: rgba(39,41,43,0.03);">
                        <div class="col" style="border: 1px solid rgba(39,41,43,0.1);">
                            {{ __('First Name') }}
                        </div>
                        <div class="col" style="border: 1px solid rgba(39,41,43,0.1);">
                            {{ __('Last Name') }}
                        </div>
                        <div class="col" style="border: 1px solid rgba(39,41,43,0.1);">
                            {{ __('Phone') }}
                        </div>
                        <div class="col" style="border: 1px solid rgba(39,41,43,0.1);">
                            {{ __('Photo') }}
                        </div>
                        
                    </div>
                    
                    @foreach($shopowners ?? [] as $shopowner)
                    <div class="row shopowner table table-hover" data-id="{{$shopowner->id}}" style="">
                        <div class="col" style="border: 1px solid rgba(39,41,43,0.1);">
                            {{ __($shopowner->first_name) }}
                        </div>
                        <div class="col" style="border: 1px solid rgba(39,41,43,0.1);">
                            {{ __($shopowner->last_name) }}
                        </div>
                        <div class="col" style="border: 1px solid rgba(39,41,43,0.1);">
                            {{ __($shopowner->phone) }}
                        </div>
                        <div class="col" style="border: 1px solid rgba(39,41,43,0.1);">
                            <img src="{{ __($shopowner->profile_photo()) }}" />
                        </div>
                        
                    </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
<script>
window.addEventListener('load', function() {
                            $(".shopowner").on("click", function(){
                                
                                var id = $(this).attr("data-id");
                                var url = "{{ url('shopowners/') }}/"+id;
                                
                                window.location = url;                           
                                
                            });
                        })
</script>
