@extends('layouts.admin')

@section('content')
<style>
.fieldofficer{
    cursor:hand; 
    background: #fff;
}
.fieldofficer:hover {background: #f5f5f5;}
.fieldofficer img{
    width:50px;
    height:50px;
}
</style>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">{{ __('View All Field Officers/Search For All Officers') }}</div>

                <div class="card-body">
                    @if (session('status'))
                        <div class="alert alert-success" role="alert">
                            {{ session('status') }}
                        </div>
                    @endif
                    @if(Session::has('fail'))
                        <div class="alert alert-danger">
                        {{Session::get('fail')}}
                        </div>
                    @endif

                    <div class="row">
                        <div class="col">
                            <a href="{{ url('fieldofficers/create') }}" class="btn btn-outline-success" >Create Field Officer</a>
                        </div>
                    </div>
                </div>

            </div>
            
            <div class="card">
                <div class="card-header">{{ __('Search/Filter') }}</div>

                <div class="card-body">
                    <form action="{{ url('/admin-fieldofficers-search') }}" method="get">
                        <div class="input-group mb-3">
                            <input type="hidden" name="search_by" value="name"/>
                            <input type="text" name="name" class="form-control" placeholder="Enter First Name" aria-label="Enter Allocation No" aria-describedby="button-addon2">
                            <button class="btn btn-outline-success" type="sumbit" id="">Search</button>
                        </div>
                    </form>
                    
                    
                </div>
            </div>
            <div class="card">
                <div class="card-header">{{ __('Result/List') }}</div>

                <div class="card-body">
                    <div class="row" style="background-color: rgba(39,41,43,0.03);">
                        <div class="col" style="border: 1px solid rgba(39,41,43,0.1);">
                            {{ __('First Name') }}
                        </div>
                        <div class="col" style="border: 1px solid rgba(39,41,43,0.1);">
                            {{ __('Last Name') }}
                        </div>
                        <div class="col" style="border: 1px solid rgba(39,41,43,0.1);">
                            {{ __('Phone') }}
                        </div>
                        <div class="col" style="border: 1px solid rgba(39,41,43,0.1);">
                            {{ __('Photo') }}
                        </div>
                        
                    </div>
                    
                    @foreach($fieldofficers ?? [] as $fieldofficer)
                    <div class="row fieldofficer table table-hover" data-id="{{$fieldofficer->id}}" style="">
                        <div class="col" style="border: 1px solid rgba(39,41,43,0.1);">
                            {{ __($fieldofficer->first_name) }}
                        </div>
                        <div class="col" style="border: 1px solid rgba(39,41,43,0.1);">
                            {{ __($fieldofficer->last_name) }}
                        </div>
                        <div class="col" style="border: 1px solid rgba(39,41,43,0.1);">
                            {{ __($fieldofficer->phone) }}
                        </div>
                        <div class="col" style="border: 1px solid rgba(39,41,43,0.1);">
                        <img src="{{ $fieldofficer->profile_photo() }}" />
                        </div>
                        
                    </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
<script>
window.addEventListener('load', function() {
                            $(".fieldofficer").on("click", function(){
                                
                                var id = $(this).attr("data-id");
                                var url = "{{ url('fieldofficers/') }}/"+id;
                                window.location = url;                           
                                
                            });
                        })
</script>
