<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ShopOwner extends Model
{
    use HasFactory;

    public function shop()
    {
        return $this->hasMany('App\Models\Shop');
    }

    public function shopOwnershipHistory()
    {
        return $this->hasMany('App\Models\ShopOwnership');
    }

    public function name()
    {
        return $this->first_name." ".$this->last_name;
    }
    public function profile_photo(){
        return asset('storage/app/'.$this->profile_photo);
    }
}
