<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\ShopOwner;
use Illuminate\Support\Facades\DB;

class ShopOwnersController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //get a list of all businesses belonging to the user
        $shopowners = ShopOwner::all();
        return view('admin.shopowners.index')->with('shopowners',$shopowners);
    }
    public function filter($filter_by, $filter_value)
    {
        //get a list of all businesses belonging to the user
        $shops = Shop::all();
        return view('admin.shops.index')->with('shops',$shops);
    }
    public function search(Request $request)
    {
        if($request->search_by == 'name'){
 
            $shopowners = ShopOwner::where('first_name','LIKE',"{$request->name}%")->get();
            if(count($shopowners)>0){
                return view('admin.shopowners.index')->with('shopowners', $shopowners);
            }
            else{
                return redirect('shopowners')->withFail('Shop Owner not found');
            }
            
        }
    }
    public function searchAjax(Request $request)
    {
        $validatedData = $request->validate([
            'name' => ['required'],
        ]);
        $result = DB::table('shop_owners')
            ->where('first_name', 'like', $request->name. '%')
            ->get(); 
            if(count($result)>0){
                return response()->json(array('shopowners'=> $result), 200);
                //return "OK";
            }
            else{
                return response()->json(array('shopowners'=> ""), 200);
                //return "Not Found";
            }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.shopowners.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //validate customer entry, store and set view to list of customers
        $validatedData = $request->validate([
            'firstname' => ['required'],
            'lastname' => ['required'],
            'phone' => ['required'],
        ]);

        $shopowner = new ShopOwner;
        if($request->photo != ""){

            $allowedfileExtension=['jpeg','jpg','png'];
    
            $name = $request->file('photo')->getClientOriginalName();
            $extension = $request->photo->getClientOriginalExtension();
            $check = in_array($extension,$allowedfileExtension);
            if($check){
                $path = $request->file('photo')->store('public/images/profile_images');
                
                $shopowner->profile_photo = $path;
            }
        }
          
        $shopowner->first_name = $request->firstname;
        $shopowner->last_name = $request->lastname;
        $shopowner->phone = $request->phone;

        $shopowner->save();
        
        return redirect('shopowners')->with('status', 'Shop Owner was added successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $shopowner = ShopOwner::findOrFail($id);
        return view('admin.shopowners.show')->with('shopowner',$shopowner);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $validatedData = $request->validate([
            'firstname' => ['required'],
            'lastname' => ['required'],
            'phone' => ['required'],
        ]);

        $shopowner = ShopOwner::find($id);
        if($request->photo != ""){

            $allowedfileExtension=['jpeg','jpg','png'];
    
            $name = $request->file('photo')->getClientOriginalName();
            $extension = $request->photo->getClientOriginalExtension();
            $check = in_array($extension,$allowedfileExtension);
            if($check){
                $path = $request->file('photo')->store('public/images/profile_images');
                
                $shopowner->profile_photo = $path;
            }
        }
          
        $shopowner->first_name = $request->firstname;
        $shopowner->last_name = $request->lastname;
        $shopowner->phone = $request->phone;

        $shopowner->save();
        
        return redirect('shopowners')->with('status', 'Shop Owner was updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

}
