<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Auth;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        //return view('home');
        if(Auth::user()->user_type == "admin"){
            return view('admin.dashboard');
        }
        //else as user is client
        if(Auth::user()->user_type == "fieldofficer"){
            return view('fieldofficer.dashboard');
        }
    }
}
