<?php
/*********=============== Sidebar ============*****************/
if(!function_exists('micky_sidebar')){
	function micky_sidebar(){
		get_sidebar();
	}
}
/*********=============== add a menu start ============*****************/
if(!function_exists('micky_menu_editor')){
 function micky_menu_editor($args){
	    if ( ! current_user_can( 'edit_theme_options' ) ){
		    return;
	   	}
        // see wp-includes/nav-menu-template.php for available arguments
        extract( $args );
        $link = $link_before
              . '<a href="' .esc_url(admin_url( 'nav-menus.php' )) . '">' . $before . esc_html__('Add a menu','micky') . $after . '</a>'
             . $link_after;
        // We have a list
       if ( FALSE !== stripos( $items_wrap, '<ul' )
        
	       or FALSE !== stripos( $items_wrap, '<ol' )
		)
		{
			$link = "<li>$link</li>";
		}
		$output = sprintf( $items_wrap, $menu_id, $menu_class, $link );
		if ( ! empty ( $container ) ){
			$output  = "<$container class='$container_class' id='$container_id'>$output</$container>";
		}
		if ( $echo ){
			echo "$output";
		}
		return $output;
	}
}
/*********=============== custom comment ============*****************/
function micky_custom_comments($comment, $args, $depth){
	extract($args, EXTR_SKIP);
	if ( 'div' == $args['style'] ) {
		$tag = 'div';
		$add_below = 'comment';
	}else{
		$tag = 'li';
		$add_below = 'div-comment';
	}
?>
	<<?php echo esc_attr($tag); ?> <?php comment_class( empty( $args['has_children'] ) ? '' : 'parent' ) ?> id="comment-<?php comment_ID() ?>">
	<?php if ( 'div' != $args['style'] ) : ?>
	<div id="div-comment-<?php comment_ID() ?>" class="">
	<?php endif; ?>
		
		<div class="micky_comment_main">
			<div class="blog_avtar"> 
				<?php echo get_avatar($comment,$size='70') ?>
			</div>
			<div class="micky_comment_data">
				<div class="author_title">
				  <h5><?php echo esc_html($comment->comment_author); ?></h5> 
				  <span class="comment_date"><a><?php echo  esc_html( get_comment_date() ); ?></a></span>
				  <span class="comment_time"><?php comment_time('H:i:a')  ?></span>
				  <?php comment_reply_link( array_merge( $args, array(  'add_below' => $add_below,'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ); ?>
				 </div>
				 <?php if ( $comment->comment_approved == '0' ) { ?>
				<?php echo esc_html__( 'Your comment is awaiting moderation.','micky' ); ?>
				<?php }else{ ?>		
				<?php comment_text(); } ?>
			</div>
		</div>
		
	<?php if ( 'div' != $args['style'] ) : ?>
	</div>
	<?php endif; ?>
	<?php
}
/*********============ custom comment fields ==========*****************/
add_filter( 'comment_form_default_fields', 'micky_comment_form_fields' );
function micky_comment_form_fields( $fields ) {
	$commenter = wp_get_current_commenter();
	$aria_req = " aria-required='true'";
    unset($fields['author']);
    unset($fields['email']);
    unset($fields['url']);

		$fields['author'] = '<div class="col-sm-6"><input id="author" name="author" type="text" placeholder="'.esc_attr__('Name&hellip;','micky').'" value="' . esc_attr( $commenter['comment_author'] ) . '" class="form-control" size="30"' . $aria_req . ' /></div>';
		$fields['email']  = '<div class="col-sm-6"><input id="email" name="email" type="email" placeholder="'.esc_attr__('Email&hellip;','micky').'" value="' . esc_attr(  $commenter['comment_author_email'] ) . '" class="form-control" size="30"' . $aria_req . ' /></div>';

	return $fields;
}
add_filter( 'comment_form_defaults', 'micky_comment_form_defaults' );
function micky_comment_form_defaults( $defaults ) {

	$defaults['title_reply'] = '';
	$defaults['id_submit'] = 'comments_button';
	$defaults['label_submit'] = esc_html__( 'Send Comment', 'micky' );
	$defaults['comment_notes_before'] = '';
	$defaults['comment_notes_after'] = '';
	$defaults['comment_field'] = '<div class="col-lg-12"><textarea name="comment" rows="3" placeholder="'.esc_attr__('Comment&hellip;','micky').'" class="comment_textarea"></textarea></div>';
	$defaults['class_submit'] = 'comment_button';
	return $defaults;
}
/********************* start global variables function ****************************/
function micky_post_variables(){
	global $post;
	return $post;
}  
/*********************** Require File Start **********************************/
require_once get_template_directory() . '/vendor/include/micky-enqueue.php';
/************************* Require File End ************************************/
?>