<?php
/**
 * The header for our theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package micky
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="profile" href="http://gmpg.org/xfn/11">
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<div class="main_wrapper_cover">
<header>
<div class="wrapper_main header_top_main">
   <div class="container">
    <div class="row">
     <div class="full_width header_navigation">
      <div class="col-sm-3">
	   <div class="mk_logo">
	   <?php the_custom_logo();?>
		<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
	   </div>
	  </div>
      <div class="col-sm-9">   
       <!-- navbar toggle start -->
		  <div class="navbar-header pull-right">
			  <button type="button" class="navbar-toggle navbar_toogle" data-toggle="collapse" data-target="#myNavbar"> 
				<i class="fa fa-list-ul"></i> 
			  </button>
		  </div>
       <!-- navbar toggle end--> 
       <!-- navigation start -->
       <div class="mk_top_navigations">
	   <?php wp_nav_menu( array( 'theme_location'  => 'micky','depth' => 4 ,'menu_class' => 'menu','container' => false,'fallback_cb'=>'micky_menu_editor')); ?>
		
        </div>
       <!-- navigation end --> 
      </div>
      <!-- header_navigation_cover --> 
     </div>
    </div>
   </div>
  </div>
  <!--  header navigation end --> 
</header>